<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Edit Task</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet" />
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet" />

    <style>
        body {
            background: #f4f6f9;
            font-family: "Inter", sans-serif;
        }
        .topbar {
            background: #145da0;
            padding: 6px 24px;
            color: #fff;
            box-shadow: 0 2px 6px rgba(0,0,0,0.15);
        }
    </style>
</head>

<body>

<!-- Top Bar -->
<div class="topbar d-flex align-items-center">
    <img src="{{ asset('logo2.png') }}" style="margin-right:10px;" width="35" alt="">
    <h4 class="mb-0 fw-bold">Task Management System</h4>
</div>

<!-- Body -->
<div class="container py-5">
    <div class="card p-4 shadow-sm rounded-4">
        <h4 class="mb-4">Edit Task</h4>

        {{-- Validation Errors --}}
        @if ($errors->any())
            <div class="alert alert-danger">
                <ul class="mb-0">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif

        <form action="{{ route('tasks.update', $task->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="row g-4">

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Task Name</label>
                    <input type="text"
                           name="task_name"
                           class="form-control form-control-lg"
                           value="{{ old('task_name', $task->task_name) }}"
                           required>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Project Name</label>
                    <input type="text"
                           name="project_name"
                           class="form-control form-control-lg"
                           value="{{ old('project_name', $task->project_name) }}"
                           required>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Module</label>
                    <input type="text"
                           name="module"
                           class="form-control form-control-lg"
                           value="{{ old('module', $task->module) }}"
                           required>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Task Date</label>
                    <input type="date"
                           name="task_date"
                           class="form-control form-control-lg"
                           value="{{ old('task_date', $task->task_date) }}"
                           required>
                </div>

                <div class="col-md-6">
                    <label class="form-label fw-semibold">Deadline</label>
                    <input type="date"
                           name="deadline"
                           class="form-control form-control-lg"
                           value="{{ old('deadline', $task->deadline) }}"
                           required>
                </div>

            </div>

            <div class="mt-4">
                <button type="submit" class="btn btn-primary btn-lg px-4">
                    <i class="bi bi-check-circle"></i> Update Task
                </button>

                <a href="{{ route('tasks.index') }}" class="btn btn-secondary btn-lg ms-2">
                    Cancel
                </a>
            </div>
        </form>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
